package etradeproject;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.sql.*;

public class addToBasket extends HttpServlet
{
  static final private String CONTENT_TYPE = "text/html; charset=windows-1251";
  //Initialize global variables
  public void init() throws ServletException
  {
  }
  //Process the HTTP Get request
  public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
  {
    response.setContentType(CONTENT_TYPE);

    Product product = (Product) request.getSession().getAttribute("currentProduct");
    Basket basket = (Basket) request.getSession().getAttribute("basket");
    Long orderId = (Long) request.getSession().getAttribute("orderId");
    User user = (User) request.getSession().getAttribute("user");

    float quantity = 0;
    try
    {
      quantity = Float.parseFloat(request.getParameter("quantity"));
    }
    catch(Exception e){}

    try
    {
      Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
      Connection con = DriverManager.getConnection("jdbc:odbc:storeDB", "sa", "");

      Statement stmt = con.createStatement();
      ResultSet rs = null;

      if(orderId==null)
      {
        // Creates a new order with default value (0) to completed field.
        stmt.executeUpdate("INSERT INTO Orders(user_id) VALUES(" + user.getUserId() + ")");

        // Gets genarated order_id
        rs = stmt.executeQuery("SELECT * FROM Orders WHERE user_id = " + user.getUserId() + " AND completed = 0");

        if(rs.next())
          orderId = new Long(rs.getLong("order_id"));

        request.getSession().setAttribute("orderId", orderId);

        rs.close();
      }

      if(orderId!=null)
      {
        // Some kind of transaction - transaction ends on con.commit() method.
        con.setAutoCommit(false);

        stmt.executeUpdate("DELETE FROM OrderProduct WHERE order_id = " + orderId.longValue());

        PreparedStatement st =
          con.prepareStatement("INSERT INTO OrderProduct(order_id, product_id, quantity) VALUES(?, ?, ?)");

        basket.addToBasket(product, quantity);

        Product basketProduct;

        for(int i=0; i<basket.products.size(); i++)
        {
          basketProduct = (Product) basket.products.get(i);

          st.setInt(1, orderId.intValue());
          st.setInt(2, basketProduct.getProductId());
          st.setFloat(3, basketProduct.getQuantity());

          st.execute();
        }

        st.close();
        con.commit(); // end of transaction
      }

      stmt.close();
      con.close();

      request.getSession().setAttribute("basket", basket);
    }
    catch (Exception ex)
    {
      System.out.println("       : " + ex.toString());
    }

    response.sendRedirect("product.jsp?pId=" + product.getProductId());
  }
  //Process the HTTP Post request
  public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
  {
    doGet(request, response);
  }
  //Clean up resources
  public void destroy()
  {
  }
}